IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_BI_PG_CRED]'))
DROP VIEW [DBO].[V_BI_PG_CRED]    
GO
--select * from V_BI_PG_CRED WHERE Fornecedor = 73
CREATE VIEW V_BI_PG_CRED AS
SELECT
	PG_CRED.CD_FILIAL as Filial,
	dtVenc.CD_CTR_DT_MOVIMENTO AS CdDataVencto,
	PG_CRED.CD_FORN as Fornecedor,
	PG_CRED.VLR_DP as Duplicata,
	PG_CRED.VLR_DESC as Desconto,
	PG_CRED.VLR_JUROS as Juros,
	PG_CRED.VLR_DESP_OUTR as Despesas,
	PG_CRED.VLR_DEVOLUCAO as Devolucao,
	ISNULL(V_PG_CRED_IMPOSTO.VLR_IMP, 0) as Imposto,
   CASE WHEN  PG_CRED.STS_DP = 3 THEN 
        'CANCELADA' 
    WHEN PG_CRED.STS_DP = 0 THEN
       'NÃO LIQUIDADA' 
    WHEN PG_CRED.STS_DP = 1 THEN
       'LIQUIDADA' 
    WHEN PG_CRED.STS_DP = 2 THEN
       'LIQUIDADA PARCIALMENTE' 
    WHEN PG_CRED.STS_DP = 3 THEN
       'CANCELADA' 
    WHEN PG_CRED.STS_DP = 5 THEN
       'AGUARDANDO RETORNO BANCO (CNAB)' 
    WHEN PG_CRED.STS_DP = 6 THEN
       'PAGAMENTO AGENDADO' 
    WHEN PG_CRED.STS_DP = 7 THEN
       'REJEITADA(CNAB)' 
   END AS StatusDuplicata
   FROM
	PG_CRED INNER JOIN GLB_DT_MOVIMENTO dtVenc ON
	PG_CRED.DT_VENCTO =  dtVenc.DT_MOVIMENTO
	LEFT OUTER JOIN V_PG_CRED_IMPOSTO ON 
	PG_CRED.CD_EMP = V_PG_CRED_IMPOSTO.CD_EMP AND 
	PG_CRED.CD_FILIAL = V_PG_CRED_IMPOSTO.CD_FILIAL AND 
    PG_CRED.CD_PG_CRED = V_PG_CRED_IMPOSTO.CD_PG_CRED
WHERE
	PG_CRED.STS_DP <> 3